
IF EXISTS
(
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS 
		WHERE TABLE_NAME = 'PG_DEB' AND COLUMN_NAME = 'UUID'
		AND DATA_TYPE = 'varchar'
)
BEGIN

	ALTER TABLE dbo.PG_DEB DROP CONSTRAINT DF_PG_DEB_UUID ;	
	ALTER TABLE dbo.PG_DEB ALTER COLUMN UUID uniqueidentifier  NULL;
	ALTER TABLE dbo.PG_DEB ADD CONSTRAINT
		DF_PG_DEB_UUID DEFAULT NEWID() FOR UUID;
END
go

IF NOT EXISTS
(
    SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PG_DEB' AND COLUMN_NAME = 'UUID'
)
BEGIN
	ALTER TABLE dbo.PG_DEB ADD
		UUID uniqueidentifier  NULL;

	ALTER TABLE dbo.PG_DEB ADD CONSTRAINT
		DF_PG_DEB_UUID DEFAULT NEWID() FOR UUID;
END